/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWSchema;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.dialog.VWCorrelationSetPanel;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWCorrelationSetPropertiesTableModel;
import filenet.vw.toolkit.design.property.tables.VWReceiveCorrelationSetPropertiesTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;

class VWReceiveCorrelationSetPanel
extends VWCorrelationSetPanel {
    private VWReceiveInstruction m_receiveInstruction = null;

    public VWReceiveCorrelationSetPanel(VWAuthPropertyData authPropertyData) {
        super(authPropertyData);
        this.init();
    }

    protected void onUpdateName() {
        String oldName = null;
        try {
            if (this.m_receiveInstruction != null && VWStringUtils.compare(oldName = this.m_receiveInstruction.getCorrelationSetName(), this.m_name.getText()) != 0) {
                this.m_receiveInstruction.setCorrelationSetName(this.m_name.getText());
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (this.m_authPropertyData != null) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
            this.m_name.setText(oldName);
            this.m_name.requestFocus();
        }
    }

    protected void reinitialize(VWInstructionDefinition instructionDef) {
        if (instructionDef instanceof VWReceiveInstruction) {
            this.m_receiveInstruction = (VWReceiveInstruction)instructionDef;
            this.m_name.setText(this.m_receiveInstruction.getCorrelationSetName());
            this.m_propertiesTableModel.reinitialize(this.m_receiveInstruction);
            this.m_sampleMsgTextArea.setText(this.getSampleMessage());
        }
    }

    protected VWCorrelationSetPropertiesTableModel createCorrelationSetPropertiesTableModel() {
        return new VWReceiveCorrelationSetPropertiesTableModel(this.m_authPropertyData);
    }

    private String getSampleMessage() {
        try {
            VWWebServiceUtils wsUtils;
            VWSchema vwSchema;
            String schemaFieldName = null;
            String elementName = null;
            String schema = null;
            if (this.m_receiveInstruction != null) {
                schemaFieldName = this.m_receiveInstruction.getMessageFromSchemaName();
                elementName = this.m_receiveInstruction.getMessageFromElementName();
            }
            if (this.m_authPropertyData != null && (vwSchema = this.m_authPropertyData.getSchema(schemaFieldName)) != null) {
                schema = vwSchema.getSchema();
            }
            if ((wsUtils = this.m_authPropertyData.getWebServiceUtils()) != null && schema != null && schema.length() > 0) {
                return wsUtils.getXMLTemplate(schemaFieldName, schema, elementName);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return VWResource.s_unableToRetrieveSampleMessage;
    }
}

